/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.v8dtoa;

class DiyFp {
    private long f;
    private int e;
    static final int kSignificandSize = 64;
    static final long kUint64MSB = Long.MIN_VALUE;

    DiyFp() {
        this.f = 0L;
        this.e = 0;
    }

    DiyFp(long f2, int e) {
        this.f = f2;
        this.e = e;
    }

    private static boolean uint64_gte(long a, long b) {
        return a == b || a > b ^ a < 0L ^ b < 0L;
    }

    void subtract(DiyFp other) {
        assert (this.e == other.e);
        assert (DiyFp.uint64_gte(this.f, other.f));
        this.f -= other.f;
    }

    static DiyFp minus(DiyFp a, DiyFp b) {
        DiyFp result2 = new DiyFp(a.f, a.e);
        result2.subtract(b);
        return result2;
    }

    void multiply(DiyFp other) {
        long kM32 = 0xFFFFFFFFL;
        long a = this.f >>> 32;
        long b = this.f & 0xFFFFFFFFL;
        long c = other.f >>> 32;
        long d = other.f & 0xFFFFFFFFL;
        long ac = a * c;
        long bc = b * c;
        long ad = a * d;
        long bd = b * d;
        long tmp = (bd >>> 32) + (ad & 0xFFFFFFFFL) + (bc & 0xFFFFFFFFL);
        long result_f = ac + (ad >>> 32) + (bc >>> 32) + ((tmp += 0x80000000L) >>> 32);
        this.e += other.e + 64;
        this.f = result_f;
    }

    static DiyFp times(DiyFp a, DiyFp b) {
        DiyFp result2 = new DiyFp(a.f, a.e);
        result2.multiply(b);
        return result2;
    }

    void normalize() {
        assert (this.f != 0L);
        long f2 = this.f;
        int e = this.e;
        long k10MSBits = -18014398509481984L;
        while ((f2 & 0xFFC0000000000000L) == 0L) {
            f2 <<= 10;
            e -= 10;
        }
        while ((f2 & Long.MIN_VALUE) == 0L) {
            f2 <<= 1;
            --e;
        }
        this.f = f2;
        this.e = e;
    }

    static DiyFp normalize(DiyFp a) {
        DiyFp result2 = new DiyFp(a.f, a.e);
        result2.normalize();
        return result2;
    }

    long f() {
        return this.f;
    }

    int e() {
        return this.e;
    }

    void setF(long new_value) {
        this.f = new_value;
    }

    void setE(int new_value) {
        this.e = new_value;
    }

    public String toString() {
        return "[DiyFp f:" + this.f + ", e:" + this.e + "]";
    }
}

